# Copyright: Tian Chen and Michael Monagan, 2024

read "CMSHL_NMContLI3.mpl";
read "MakeBlackBoxes.mpl";

# ------------- Initial settings ---------------------------
# ---- Choose a black box mode for creating a black box ----
# 1. BBMPoly: Uses a given polynomial a in Z[x1,...,xn] to generate a
#             modular black box Bm(alpha,p)=a(alpha) mod p. 
# 2. BBdet: Uses a matrix A with entries in Z[x1,...,xn] to create a
#            modular black box Bm(alpha,p)=det(A(alpha)) mod p.
BBMode := BBMPoly: 
 
# --- For BBdet ONLY ---
# BBdetCode = C: both BBeval and BBdet coded in C, for general (non-structured) matrices
# BBdetCode = Maple: both BBeval and BBdet coded in Maple. 
BBdetCode := C:

# ---- Choose a test example ----
# BBMPoly: testex = 0,1,2,3;
# BBdet: testex = 0,1,...,9.
testex := 2:

# --------------- For CMBBSHL ---------------
# ---- Choose p and Ntilde ----
p := prevprime(2^62-1):
Ntilde := 4001: # Ntilde as in our ISSAC 2023 paper

# ---- Options for content and square-free computation ----
Cont_Flag := 1: # 0 or 1 for content computation in a chosen variable
sqfinterp := 0: # 0 or 1 for an option to use SquareFreeImage

# ---- Choose Maple or C code for each subroutine ----
# Subroutines: 1. Bivariate interp, 2. Eval fjm1, 3. BHL, 4. Vandermonde Solves.
# For large integer coefficients, use Maple code for all. 
MapleCode := [C,C,C,C]:
# ------------- End of initial settings ---------------------

C := 0: Maple := 1:
LI := 0: # for large integer coeffs
printf("Cont_Flag=%d, sqfinterp=%d, MapleCode=%a, LargeInt=%a\n", Cont_Flag, sqfinterp, MapleCode, LI);
randzp := rand(p):
randzp1 := rand(Ntilde): 

# Read in data and create black boxes 
if BBMode = `BBMPoly` then 
    # Make a black box from a given polynomial a in Z[x1,...,xn]
    if testex = 0 then a := 232;
    elif testex = 1 then 
        a := 299*(x^2+x+1)*(3*x+19);
    elif testex = 2 then 
	a := (x1+x2+x3+1)*(x2+x3+1);
    elif testex = 3 then 
	a := (x1+x3+3*x4^2+2)*(31*x1^2*x3+x2+3*x4+1)*(x3+2)*(x2+1)^2*(x4+3); 
    fi;
    X := convert(indets(a),list); printf("a = %a, X = %a\n",a,X); 
    N := nops(X);
    # ---- OPTIONAL: Choose a variable permutation ----
    # VarPermGen(N,opt,MainVar)
    # opt = 0, no perm; opt = 1, reverse; opt = 2, random perm;
    # opt > 2, choose a MainVar between 1 to N, swap with the first variable. 
    VPL := VarPermGen( N, 3, 2 );
    # -------------------------------------------------
    Var_Perm := VPL[1]; # indicator for variable permutation, 0 or 1.
    VP := VPL[2]; # A list of variable permutation.
    Xnew := Array(1..N); 
    for i to N do Xnew[i] := X[VP[i]]; od;
    Xnew := convert(Xnew,list);
    BBInput := MakeBBMPoly( a, VP ); # Outputs procedure BB_MPoly(alpha,p)
elif BBMode = `BBdet` then 
    # Make a black box for det(A)
    # ----- Choose a matrix for testex 0,1,2,8,9 ONLY -----
    # --- For testex 0 ----------
    n0 := 4: # The size of the square matrix. For Toeplitz, need n0>=1.
    # --- For testex 1,2,8,9: B||m, T||m, TL||m, BL||m
    # m := 5;
    # --- For testex 6 (robotarms): m = 1,2,3,4 for b1,b2,t1,t2 ---
    m := 9;
    # -----------------------------------------------------
    if testex = 0 then 
        #A := LinearAlgebra:-RandomMatrix(n0,n0,generator=-1000..1000); 
        v := <seq(x||i,i=1..n0)>;
        A := LinearAlgebra:-VandermondeMatrix(v);
       # A := LinearAlgebra:-ToeplitzMatrix(v,symmetric);
    elif testex = 1 then 
	reader := subs(FILENAME=B||m, proc() read FILENAME; end); reader();
    elif testex = 2 then 
	reader := subs(FILENAME=T||m, proc() read FILENAME; end); reader();
	A := T||m; 
    elif testex = 3 then 
        #reader := subs(FILENAME=heron3dA, proc() read FILENAME; end); reader(); 
	reader := subs(FILENAME=heron3dB, proc() read FILENAME; end); reader(); A := B; 
    elif testex = 4 then 
	reader := subs(FILENAME=heron4dB, proc() read FILENAME; end); reader();
	A := B; 
    elif testex = 5 then  
	reader := subs(FILENAME=heron5dB, proc() read FILENAME; end); reader();
	A := B; 
    elif testex = 6 then
        if m = 1 then ReadFileName := robotarmsB_b1; 
        elif m = 2 then ReadFileName := robotarmsB_b2; 
        elif m = 3 then ReadFileName := robotarmsB_t1;
        elif m = 4 then ReadFileName := robotarmsB_t2;  
        fi; 
	reader := subs(FILENAME=ReadFileName, proc() read FILENAME; end); reader();
        A := B;
    elif testex = 7 then 
	reader := subs(FILENAME="LinearSystem.mpl", proc() read FILENAME; end); reader();
    elif testex = 8 then # Large Interger case TL4-TL9: p is read-in 
	reader := subs(FILENAME=TLI||m, proc() read FILENAME; end); reader();
	A := TL||m; 
        LI := 1;
    elif testex = 9 then # Large Integer case BL4-BL9: p is read-in
	reader := subs(FILENAME=BLI||m, proc() read FILENAME; end); reader();
	p := nextprime(p^2);
        A := BL||m; 
        LI := 1; 
    fi; 
printf("A = %a\n",A);
    X := convert(indets(A),list); 
    N := nops(X);
    n := LinearAlgebra:-RowDimension(A); 
    # ---- OPTIONAL: Choose a variable permutation ----
    # VarPermGen(N,opt,MainVar)
    # opt = 0, no perm; opt = 1, reverse; opt = 2, random perm;
    # opt > 2, choose a MainVar between 1 to N, swap with the first variable. 
    #VPL := VarPermGen( N, 0, 1 );
    VPL := [1,[6,2,3,4,1,5,7,8,9,10,11]];
    # -------------------------------------------------
    Var_Perm := VPL[1]; # indicator for variable permutation, 0 or 1.
    VP := VPL[2]; # List of variable permutation.
    Xnew := Array(1..N); 
    for i to N do Xnew[i] := X[VP[i]]; od;
    Xnew := convert(Xnew,list);
    if BBdetCode = `C` then 
        BBInput := MakeBBdet_C( A, VP ); 
    elif BBdetCode = `Maple` then
        BBInput := MakeBBdet_Maple( A, VP, 2 ); # The 3rd argument = 2: Use GE for det
    fi;
fi:

# Select alpha's at random:
if LI = 0 then alpha := Array([seq(randzp1(),i=1..N)],datatype=integer[8]);
else alpha := Array([seq(randzp1(),i=1..N)]);
fi:

printf("No.of variables = %d\n", N);
printf("    X = %a\n Xnew = %a\n",X, Xnew);
printf("Variables permutated? %a\n Variable perm = %a\n", VPL[1], VP);
printf("Large Integer? LI = %d\n", LI);
printf("alpha = %a\n",alpha); 
      
# Compute a total degree bound
if BBMode = `BBdet` then tdegbd := 0:
    for ii to n do maxdeg[ii] := -1; 
        for jj to n do dd := degree(A[ii,jj]);
            if dd > maxdeg[ii] then maxdeg[ii] := dd; fi; 
        od;
        tdegbd += maxdeg[ii];
    od:
else tdegbd := degree(a);
fi:
printf("total deg bound = %a\n", tdegbd);

#st := time():
#d := LinearAlgebra:-Determinant(A,method=minor): 
#et := time()-st: printf("det minor time = %f\n", et);
#st := time(): 
#dfac := factor(d): 
#printf("factors of d = %a\n", dfac); 
#et := time()-st: printf("Maple factor time = %f\n", et);

# Compute deg(a,xj) w.h.p. 
CNT := 0: tBBeval := 0: tBBdet := 0: 
st := time():
for j to N do #printf("j = %d\n",j); 
    deg[j] := degB(BBInput,N,j,p,tdegbd,LI); 
od:
et := time()-st: printf("time for degree computation = %f\n", et);
degA := [seq(deg[j],j=1..N)]: 
printf("degA = %a\n", degA);
printf("no.of probes for deg compt = %d\n", CNT):
printf("total times for BB in deg compt: BBeval = %f, BBdet = %f\n", tBBeval,tBBdet);

#trace(CMBBSHLcont); 
#trace(CMBBSHL);
#trace(CMBBSHL_stepj);

# Start CMBBSHL    
CNT := 0: tBBeval := 0: tBBdet := 0:
st := time():
ff := CMBBSHLcont( BBInput, Xnew, alpha, degA, p, Var_Perm, Cont_Flag, sqfinterp, MapleCode, LI );
et := time() - st: 
printf("Total time for CMBBSHL = %f\n", et);
printf("Total no.of probes for CMBBSHL = %d\n", CNT):

saver := subs(FILENAME=factors_ContNMLI||BBMode||testex||m, proc() save ff,FILENAME; end):
saver():

