local allocateSpace, BHL_C;
# Link to external C programs for Bivariate Hensel lifting.
# Bivariate Hensel lifting C code was written by Garrett Paluck. 
# allocateSpace is for allocating a temp work space WW in BHL_C.  

allocateSpace := define_external('allocateSpaceCubic',
  n::integer[4],
  dx::integer[8],
  dz::integer[8],
  du::integer[8],
  LIB=cat(CCodeDir, "hensel2.so"),
  RETURN::integer[8]):

BHL_C := define_external('HenselLiftCubic',
  AA::ARRAY(0..dxdz,integer[8]), dx::integer[4], dz::integer[4],
  DDX::ARRAY(1..nn,0..dy,integer[8],order=C_order), 
  DDY::ARRAY(1..nn,integer[8]),
  F0::ARRAY(1..nn,0..du,integer[8],order=C_order), nn::integer[4], du::integer[4], 
  FF::ARRAY(1..nn,0..dxdz,integer[8],order=C_order), alpha::integer[8],
  WW::ARRAY(0..dW,integer[8]),
  pp::integer[8], 
  LIB=cat(CCodeDir,"hensel2.so"),
  RETURN::integer[4]):
