local B_chrem;
# B_chrem is for Chinese remaindering to get B(alpha) in Z on several primes bigger than p.
# Input: A black box B s.t. B(alpha,p)=a(alpha) mod p for a in Z[x1,...,xn]
#        alpha = [alpha_1,...,alpha_n] in Z^n,
#        An initial prime p
# Ouput: B(alpha)=a(alpha) in Z
 
B_chrem := proc( B::procedure, 
                 alpha::Array, 
                 p::prime )
    local p0::'prime':=p, # The initial prime
          d::'integer':=B(alpha,p), # B(alpha,p)
          M::'integer':=p, # Stores the product of primes, initialized as p
          d0::'integer',
          i::'integer', # loop variable
          p1::'prime',  # The next prime
          d1::'integer'; # B(alpha,p1)
    d0 := mods(d,M); 
    for i to 2000 do # upper bound for Chinese remaindering 
        p1 := nextprime(p0); 
        d1 := B(alpha,p1); 
        d := chrem([d0,d1],[M,p1]); 
        M := M*p1; 
        d := mods(d,M);
        if d = d0 then 
            break; 
        else 
            (d0,p0) := d,p1; 
            i++; 
        end if;
    od;
    userinfo(5, 'BBfactor', `number of prime(s) used to interplate content:`, i);
    if i > 2000 then 
        error "integer content too large to be interpolated"; 
    end if; 
    return d;
end:
