local BivarPoly2matrix;
# BivarPoly2matrix stores the coefficients of a bivariate polynomial into an Array M.

BivarPoly2matrix := proc( a::polynom, 
                          X::list(name), 
                          dx::integer, 
                          M::Array ) 
    # Input: a in Zp[x,y], X=[x,y], dx=deg(a,x)
    # Output: M with A[(dx+1)*j+i] = coeff of x^j*y^i in a, i=0..dy, j=0..dx
    local cof::'list', # list of coefficients of x^j*y^i
          mon::'list(polynom)', # list of monomials x^j*y^i
          dmx::'list(integer)', # list of degrees of monomials in x
          dmy::'list(integer)', # list of degrees of monomials in y
          k::'integer'; # loop variable
    cof,mon := MonCoffs(a,X);
    dmx := map(degree,mon,X[1]); 
    dmy := map(degree,mon,X[2]);
    for k to numelems(mon) do 
        M[(dx+1)*dmy[k]+dmx[k]] := cof[k]; 
    end do;
    return; 
end:

