local evallistlist, pointer, EVALMOD1;
# EVALMOD1 evaluates a list AL of n^2 elements and stores onto an n by n matrix AA
# EVALMOD1 calls an external C program evalLIST64s. 

evallistlist := define_external('evalLIST64s',
    LL::integer[8],
    XX::integer[8],
    aa::ARRAY(1..nn,integer[8]),
    AA::ARRAY(1..nn,1..nn,integer[8]),
    pp::integer[8],
    RETURN::integer[8],
    LIB=cat(CCodeDir,"gcd8.so") ): 
evallistlist := subsop(1=(LL,XX,aa,AA,pp),eval(evallistlist)):

pointer := proc(f) 
    local MaxInt := 2^63-1; 
    return addressof(f)-4*MaxInt; 
end:

# This version evaluates into the matrix AA
EVALMOD1 := proc(AL::list,
                 X::list,
                 alpha::Array,
                 AA::Array,
                 p::integer)
    return evallistlist(pointer(AL),pointer(X),alpha,AA,p);
end:
