local GetEvaluations;
# GetEvaluations computes the evaluations of a2:=a(x1,beta_2,...,beta_{j-1},xj,beta_{j+1},...,beta_n) mod p
# and the coefficients of a2(x1,xj) are stored onto MM. 
# Input: A modular black box B s.t. B(alpha,p)=a(alpha) mod p, 
#        beta=[beta_1,...,beta_N], an evaluation point,
#        var=[vi,vj], two chosen variable indices, 
#        deg=[di,dj]=[deg(a,x_vi),deg(a,x_vj)], 
#        xx is an Array of eval pts, indexed from 0 to dmax=max(di,dj), 
#        p is a prime, 
#        singlepow = 0 or > 0, the exponent of a single power in x1 in a(x1,...,xn)
# Output: Evaluations stored onto MM = Array(0..(di+1)*(dj+1)-1,datatype=integer[8])

GetEvaluations := proc( B::procedure, # Black box of a(x1,...,xn) 
                        beta::Array,  # evaluation point
                        var::list,    # variable indices
                        deg::list,    # partial degrees
                        xx::Array,    # array of evaluation points
                        MM::Array,    # Answer array
                        p::prime,     # a prime
                        singlepow::nonnegint ) # the exponent of a single power in x1 in a(x1,...,xn)
    local alpha::'Array':=Array(beta,'datatype'='integer'[8]), # evaluation point
          i::'integer', # loop variable
          j::'integer', # loop variable
          vi::'integer':=var[1], # variable index i 
          vj::'integer':=var[2], # variable index j
          di::'inreger':=deg[1], # deg(a,x_vi)
          dj::'integer':=deg[2]; # deg(a,x_vj)
	  if singlepow > 0 then  
              for i from 0 to di do 
                  alpha[vi] := xx[i]; 
                  for j from 0 to dj do 
                      alpha[vj] := xx[j];
                      MM[(di+1)*j+i] := B( alpha, p )/alpha[vi]^singlepow mod p; 
                  end do;
              end do;
	  
          else 
	      for i from 0 to di do 
                  alpha[vi] := xx[i]; 
                  for j from 0 to dj do 
                      alpha[vj] := xx[j]; 
	              MM[(di+1)*j+i] := B( alpha, p ); 
	          end do;
              end do;
	  end if;
    return;
end:  
