local Initialf2matrix;
# Initialf2matrix stores the coefficients of a list of polynomials f0 into a matrix F0
# Input: f0 is an Array of r univariate polynomials in Zp[x] 
# Ouput: Result stored onto a 2-d Array F0 s.t. row rr is the array of coefficients of f0[rr] for rr=1..r
Initialf2matrix := proc( f0::Array(polynom), 
                         x::name, 
                         F0::Array(integer) )
    local rr::'integer', # loop variable
          i::'integer',  # loop variable
          r::'integer':=numelems(f0), # number of polynomials in the Array f0
          df0::'Array(integer)':=map(degree,f0,x); # Array of degrees of the polynomials in f0 
    for rr to r do 
        for i from 0 to df0[rr] do 
            F0[rr,i] := coeff(f0[rr],x,i); 
        end do; 
    end do;
    return;
end:

