local Interp1var;
# Interp1var interpolates a(alpha[1],...,xj,...,alpha[N]) mod p
# Input: A modular black box B that represents a(x1,...,xN), 
#        X = [x1,...,xN], a list of variables,
#        alpha in Z^N is an Array of evaluation points, 
#        deg is a list of partial degrees of all variables, 
#        N is the number of variables, 
#        j is the chosen variable index,
#        p is a prime.
# Output: a(alpha[1],...,xj,...,alpha[N]) mod p
Interp1var := proc( B::procedure, 
                    X::list, 
                    alpha::Array, 
                    deg::list, 
                    N::integer, 
                    j::posint, 
                    p::prime ) 
    local dj::'integer':=deg[j], # degree of a in xj
          xx::'Array(integer)', # points for interpolation
          i::'integer', # loop index 
          F::'Array(integer)', # values for interpolation 
          beta::'Array(integer)', 
          LI::'truefalse':=`if`(p>2^61,true,false); # Boolean for large integer case, decided if p>2^61.

    if numelems(X)<>N then 
        error "Number of variables does not equal %1",N; 
    end if;
    if j > N or j < 1 then 
        error "Chosen variable index %1 is out of range", j; 
    end if;

    beta := Array(alpha,`if`(not LI,'datatype'='integer'[8], NULL)); 
    xx := Array(1..dj+1,i->i); 
    F := Array(1..dj+1); 
    for i to dj+1 do 
        beta[j] := i; 
        F[i] := B( beta, p ); 
    end do;
    return Interp( xx, F, X[j] ) mod p;
end:
