local Interp1varZ_chrem; 
# Inter1varZ_chrem interpolates the polynomial a(alpha[1],...,alpha[j-1],xj,alpha[j+1],...alpha[N]) 
# by Chinese remaindering
# This procedure calls the procedure Interp1var 
# Input: A black box B that represents the polynomial a(x1,...,xN)
#        X = [x1,...,xN]
#        alpha in Z^N is an array of evaluation points 
#        deg is a list of partial degrees of a
#        N is the number of variables
#        j is the variable index
#        p is an initial prime
# Output: a(alpha[1],...,alpha[j-1],xj,alpha[j+1],...alpha[N]) in Z[xj] 
Interp1varZ_chrem := proc( B::procedure, 
                           X::list(name), 
                           alpha::Array(integer), 
                           deg::list(integer), 
                           N::integer, 
                           j::posint, 
                           p::prime )
    local p0::'prime':=p, # initial prime
          M::'integer':=p, # product of the primes, initialized as p
          A::'polynom':=Interp1var( B, X, alpha, deg, N, j, p ), 
          a0::'polynom', # interpolated polynomial
          a1::'polynom', # next interpolated polynomial
          p1::'prime', # next prime 
          i::'integer'; # loop variable
    a0 := mods(A,M); 
    for i from 1 to 2000 do
        p1 := prevprime(p0);
        a1 := Interp1var( B, X, alpha, deg, N, j, p1 ); 
        A := chrem([a0,a1],[M,p1]); 
        M := M*p1; 
        A := mods(A,M);
        if A = a0 then 
            break; 
        else 
            (a0,p0) := A,p1; 
            i++;
        end if;
    end;
    if i > 2000 then 
        error "Coefficients of a(%1) too large to be interpolated. Or, prime is likely too small. Try large integer option.",X[j]; 
    end if;  
    return A;
end:
