# Test #1 for BlackBoxFactorization
# A univariate polynomial 
with(BlackBoxFactor);

BBInput:=proc( alpha::Array, p::prime )  
    global CNT; CNT++;
    299*(alpha[1]^2+alpha[1]+1)*(3*alpha[1]+19) mod p; 
end:

infolevel[BBfactor]:=5;
infolevel[check_ans]:=5;

ff := BBfactor( BBInput, [x] );

# Check answer
if convert(ff,set) = {[299,1],[x^2+x+1,1],[3*x+19,1]} then 
    printf("\n OK\n\n"); 
else 
    printf("\n NOT OK\n\n");
end if;


