# Test #2 for BlackBoxFactorization
# A multivariate polynomial with one factor
with(BlackBoxFactor);

BBInput := proc( X::Array, p::prime ) global CNT; CNT++; 
    X[1]^3*X[2]^2*X[3]-9*X[1]^3-4*X[1]^2+X[1]+5 mod p;
end:

infolevel[BBfactor]:=4;
ff := BBfactor( BBInput, [x1,x2,x3] );

# Check answer
if ff = [[x1^3*x2^2*x3-9*x1^3 - 4*x1^2 + x1 + 5,1]] then
    printf("\n OK\n\n"); 
else 
    printf("\n NOT OK\n\n");
fi:
