# Test #4 for BlackBoxFactorization
# A multivariate polynomial with several factors, not all square-free
with(BlackBoxFactor);

#trace(MakeBlackBoxDet);
#trace(BBfactor);
#trace(degB_nobound);

#B := LinearAlgebra:-ToeplitzMatrix( [a,b,c,d], symmetric );
B := Matrix(3,3,[[x1+x3+3*x4^2+x2,1,1],[0,31*x1^2*x3+x2+3*x4+1,1],[0,0,(x3+2)*(x2+1)^2*(x4+3)]]);
#B := Matrix(2,2,[[x1+x2,x3],[0,x1+x2]]);

infolevel[BBfactor]:=5;
BBInput,X := MakeBlackBoxDet( B );
trace(BBInput);
#BBInput( Array([1,2,3,4]), 101 );

#mc := table([evalfac=false,interp2var=false,BHL=false,VS=false]);
ff := BBfactor( BBInput, X );

# Check answer
if convert(ff,set) = {[3*x4^2+x1+x3+2,1],[31*x1^2*x3+x2+3*x4+1,1],[x2+1,2]} then 
    printf("\n OK\n\n"); 
else 
    printf("\n NOT OK\n\n");
end if:
