local VandermondeSolve_Maple;
# VandermondeSolve_Maple solves a Vandermonde system using a quadratic algorithm. 
VandermondeSolve_Maple := proc(m::{Array,Vector,list}, 
                               v0::{Array,Vector,list}, 
                               t::integer, 
                               shift::integer, 
                               p::prime) 
    # Input: m is the list of monomial evaluations, t is size of the vector, shift = 0 or 1
    # Output: solution a of the (shifted) t by t Vandermonde system Va = v0  
    local v, i, j, M, x, a, r, s, Q, temp; 
    v := v0[1..t]; 
    M := modp1(ConvertIn(1, x), p); 
    for i to t do 
        temp := modp1(ConvertIn(x-m[i], x), p); 
        M := modp1(:-Multiply(temp, M), p); 
    end do; 
    a := Array(1..t); 
    for j to t do 
        Q := modp1(Quo(M, ConvertIn(x-m[j], x)), p); 
        r := `mod`(1/modp1(Eval(Q, m[j]), p), p); 
        Q := modp1(ConvertOut(Q), p); 
        s := `mod`(add(v[i]*Q[i], i = 1..t), p); 
        a[j] := `mod`(r*s, p); 
    end do;
    if shift = 1 then 
        for j to t do 
            a[j] := `mod`(a[j]/m[j], p); 
        end do; 
    end if;
    return a; 
end:
