local clearArray, clearArray2d;
# clearArray assigns zeros to the 1-dim array A from index1 to index2 (inclusive).
# clearArray2d assigns zeros to the 2-dim array A(indexi1..indexi2,indexj1..indexj2).

clearArray := proc( A::Array, 
                    index1::integer, 
                    index2::integer ) 
    local i::'integer'; # loop index
    for i from index1 to index2 do 
        A[i] := 0; 
    end do;
    return; 
end:

clearArray2d := proc( A::Array, 
                      indexi1::integer, 
                      indexi2::integer, 
                      indexj1::integer, 
                      indexj2::integer ) 
    local i::'integer', # loop index
          j::'integer'; # loop index
    # Clear a 2-d Array A = Array(indexi1..indexi2,indexj1..indexj2)
    for i from indexi1 to indexi2 do 
        for j from indexj1 to indexj2 do 
            A[i,j] := 0; 
        end do;
    end do;
    return; 
end:
