# degB_nobound computes the partial (individual) degrees of a in Z[x1,...,xn] represented by a black box B. 
# This procedure does not require the individual degree bound Dj as an input.
# Input: A black box B s.t. B(alpha,p)=a(alpha) mod p, 
#        N is the number of variables, 
#        j is the chosen variable index which deg(a,xj) is computed w.h.p. 
#        p is a prime
# Output: deg(a,xj) w.h.p.  
degB_nobound := proc( B::procedure, 
                      N::integer, 
                      j::posint, 
                      p::prime )::integer;
    local LI::'truefalse':=`if`(p>2^61,true,false), # Boolean for large integer case, decided if p>2^61.
          beta::'Array',
          h::'table(polynom)', # interpolated polynomials
          zeta::'integer', # A random point in Zp
          k::'integer', # loop variable
          Z::'Array':=Array(1..1001), # degree bound is 1000
          b::'Array':=Array(1..1001),
          x::'name';
    if j > N then 
        error "chosen variable index out of range"; 
    end if;
    if p < 1000 then  
        error "prime is too small";
    end if;
    # Array of evaluation point 
    beta := Array(1..N, i->rand(p)(),`if`(not LI, 'datatype'='integer'[8], NULL)); 
    
    h[0] := 0; 
    for k from 1 to 1000 do
        do zeta := rand(p)(); 
        until not member(zeta,Z); 
        (Z[k],beta[j]) := zeta,zeta; 
        b[k] := B( beta, p ); 
        h[k] := Interp(Z[1..k], b[1..k], x) mod p;
    until h[k] = h[k-1];
   
    if k > 1000 then 
        error "degree out of bound (>1000)"; 
    end if; 
    
    if h[k] = 0 then 
        return -1; # if it is a zero polynoomial, degree = -1 
    else 
        return degree(h[k],x); 
    end if;

end:

