local splitfactors;
splitfactors := proc( fL::list(list) ) 
# Input: fL is a list returned from convert(f,multiset), where f is a univariate polynomial.
# Output: Two Arrays Afac for the factors and Apow their multiplicities, integer content not stored.
# E.g. f = 4*x^3*(x-3)^2*(2*x^2+5)
#      fL = [[4,1],[x,3],[x-3,2],[2*x^2+5,1]]
#      Afac = [x,x-3,2*x^2+5] and Apow = [3,2,1], both indexed from 0. 
#      The Integer content 4 is not stored. 
    local i::'integer', # loop index
          k::'integer':=1, # loop index
          X::'set':=indets(fL), # variables in fL
          nf::'integer':=numelems(fL), # size of nf, number of square-free factors, including the integer content
          t::'type', # type of element in fL[i][1], for i=1..nf.
          Afac::'Array(polynom)', # returned Array for factors
          Apow::'Array(integer)'; # returned Array for powers
    if numelems(X) <> 1 then 
        error "Input must be a list of factors with their multiplicities of a univariate polynomial, but received %1", fL;  
    end if; 

    Afac := Array(0..nf);  
    Apow := Array(0..nf);
    Afac[0] := X[1];
   
    for i to nf do 
        t := whattype(fL[i][1]);
        if t = `+` then 
            # E.g. `factor`(3*x^2+3) outputs 3*x^2+3, the content '3' is not factored.
            # Only x^2+1 is stored, without the integer content. 
	    Afac[k] := primpart(fL[i][1],X[1]); 
            Apow[k] := fL[i][2]; 
            k++;
        elif t = `integer` then 
        elif t = `indexed` or t = `symbol` then 
            Apow[0] := fL[i][2]; 
        else 
            Afac[k] := fL[i][1];
            Apow[k] := fL[i][2];
            k++;
        end if;
    od;
    return Afac[0..k-1], Apow[0..k-1];

end;


