local support, MonCoffs, Tcof, Tmon;
# support computes the support of a polynomial
support := proc(f::polynom, X::list) 
    local m; 
    coeffs(f, X, 'm'); 
    return [m]; 
end:

# MonCoffs computes the monomials and coefficients of a polynomial
MonCoffs := proc(f::polynom, X::list) 
    local m; 
    return [coeffs(f, X, 'm')], [m];
end:

# Tcof and Tmon are called in CMBBSHL_stepj only.
Tcof := proc(T::Array, 
             r::integer, 
             i::integer, 
             rr::integer, 
             LI::truefalse) 
    local ca::'Array';
    if not LI then 
        if r = 1 then 
            return Array(op(op(op(op(op(T)[2]))[2])[i])[2],'datatype'='integer'[8]); 
        end if;
        ca := Array(op(op(op(op(op(T)[2])[rr])[2])[i])[2],'datatype'='integer'[8]);
    else 
        if r = 1 then 
            return Array(op(op(op(op(op(T)[2]))[2])[i])[2]); 
        end if;
        ca := Array(op(op(op(op(op(T)[2])[rr])[2])[i])[2]);
    end if;
    return ca;
end:

Tmon := proc(T::Array, 
             r::integer, 
             i::integer, 
             rr::integer)
    if r = 1 then 
        return op(op(op(op(op(T)[2]))[2])[i])[1]; 
    end if;
    return op(op(op(op(op(T)[2])[rr])[2])[i])[1];
end:
